import { AGENCIES, ITINERARY_CARD_QUERY, ROUTES_AND_AGENCIES_QUERY, ROUTES_AND_STOPS_QUERY } from "./queries.graphql";
import { generateGraphqlQuery } from './queries/generate-otp-query.graphql';

import { APP_OTP_GRAPHQL_URL } from "@/config/otp";
import { ZodAny, z } from "zod";
import { generatePlannerQuery } from "./queries/generate-planner-query.graphql";
import { generateRoutesQuery } from "./queries/generate-routes-query.graphql";
import { GroupedRoutes, setupRoutes } from "./routes";
import { agenciesGraphqlResponse } from "./validations/agency.graphql";

let routePromise: Promise<GroupedRoutes> | undefined
export const nullRoutes = {
  medical: [],
  medicalIds: "",
  standard: [],
  standardIds: "",
  all: [],
} satisfies GroupedRoutes

const planner = generatePlannerQuery(
  ITINERARY_CARD_QUERY,
  "QUERY",
  APP_OTP_GRAPHQL_URL,
)

const agencies = generateGraphqlQuery(
  AGENCIES,
  "AGENCIES",
  APP_OTP_GRAPHQL_URL,
  agenciesGraphqlResponse,
)

const routes = generateRoutesQuery(
  ROUTES_AND_AGENCIES_QUERY,
  "ROUTES",
  APP_OTP_GRAPHQL_URL,
)

export const otpGraphql: {
  planner: typeof planner
  stops: () => Promise<z.infer<ZodAny>>
  agencies: typeof agencies
  routes: typeof routes
  setup: () => void
  teardown: () => void

  routesCache: GroupedRoutes | undefined
} = {
  planner: planner,
  agencies: agencies,
  routes: routes,

  stops: generateGraphqlQuery(
    ROUTES_AND_STOPS_QUERY,
    "ROUTES_AND_STOPS",
    APP_OTP_GRAPHQL_URL,
    z.any(),
  ),

  setup: async () => {
    routePromise = routePromise ? routePromise : setupRoutes()
    otpGraphql.routesCache = await routePromise
  },
  teardown: () => {
    otpGraphql.routesCache = nullRoutes
    routePromise = undefined
  },

  routesCache: nullRoutes,
}
